/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.debugger;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.util.HashMap;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;
import org2.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;

public abstract class AbstractDebuggerConfiguration
implements IDebuggerConfiguration {
    protected IEclipsePreferences preferences = PHPDebugEPLPlugin.getInstancePreferences();
    private HashMap<String, String> attributes = new HashMap();
    private ICommunicationDaemon communicationDaemon;

    public void setAttribute(String id, String value) {
        String defaultValue = new DefaultScope().getNode("com.aptana.php.debug.epl").get(id, "");
        if ("".equals(defaultValue)) {
            this.attributes.put(id, value);
        } else {
            this.preferences.put(id, value);
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                PHPDebugEPLPlugin.logError(e);
            }
        }
    }

    @Override
    public String getAttribute(String id) {
        String attribute = this.attributes.get(id);
        if (attribute == null) {
            attribute = this.preferences.get(id, "");
        }
        return attribute;
    }

    public void setDebuggerId(String id) {
        this.attributes.put("id", id);
    }

    @Override
    public String getDebuggerId() {
        return this.getAttribute("id");
    }

    public void setName(String name) {
        this.attributes.put("name", name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    public abstract void setPort(int var1);

    @Override
    public abstract int getPort();

    public ICommunicationDaemon getCommunicationDaemon() {
        return this.communicationDaemon;
    }

    public void setCommunicationDaemon(ICommunicationDaemon communicationDaemon) {
        this.communicationDaemon = communicationDaemon;
    }

    @Override
    public void save() {
        PHPDebugEPLPlugin.getDefault().savePluginPreferences();
    }

    public abstract void applyDefaults();
}

